<?php
include 'conecta.php';
$result = $conn->query("SELECT * FROM localizacoes");
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Painel de Rastreamento</title>
  <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
  <style>
    #map { height: 100vh; }
  </style>
</head>
<body>
  <div id="map"></div>

  <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
  <script>
    const map = L.map('map').setView([-8.05, -34.9], 13); // Recife como centro

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    const marcadores = [
      <?php while ($row = $result->fetch_assoc()): ?>
        {
          nome: "<?= $row['nome'] ?>",
          lat: <?= $row['lat'] ?>,
          lng: <?= $row['lng'] ?>,
          icone: "<?= $row['icone'] ?>"
        },
      <?php endwhile; ?>
    ];

    marcadores.forEach(m => {
      const icon = L.icon({
        iconUrl: m.icone,
        iconSize: [32, 32],
        iconAnchor: [16, 32],
      });

      L.marker([m.lat, m.lng], {icon: icon}).addTo(map)
        .bindPopup(`<b>${m.nome}</b>`);
    });
  </script>
</body>
</html>
